/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.service;

import com.br.bthbackend.backend.domain.repository.ContributionRepository;
import com.br.bthbackend.backend.dto.pagarme.webhook.PagarmeWebhookEvent;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class WebhookService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(WebhookService.class);
    private final ContributionRepository contributionRepo;

    public void handlePagarmeEvent(PagarmeWebhookEvent event) {
        log.info("Webhook recebido: Tipo={}, Code={}, Status={}", new Object[]{event.getType(), event.getData().getCode(), event.getData().getStatus()});
        if (event.getData() == null || event.getData().getCode() == null) {
            return;
        }
        String internalCode = event.getData().getCode();
        String newStatus = event.getData().getStatus();
        String chargeId = event.getData().getId();
        this.contributionRepo.findByCode(internalCode).ifPresentOrElse(contribution -> {
            contribution.setStatus(newStatus);
            if (contribution.getPagarmeOrderId() == null) {
                contribution.setPagarmeOrderId(chargeId);
            }
            this.contributionRepo.save(contribution);
            log.info("Contribui\u00e7\u00e3o {} atualizada para status: {}", (Object)internalCode, (Object)newStatus);
        }, () -> log.warn("Contribui\u00e7\u00e3o n\u00e3o encontrada para o c\u00f3digo: {}", (Object)internalCode));
    }

    @Generated
    public WebhookService(ContributionRepository contributionRepo) {
        this.contributionRepo = contributionRepo;
    }
}

