/*
 * Decompiled with CFR 0.152.
 */
package com.br.bthbackend.backend.web;

import com.br.bthbackend.backend.domain.entity.Contribution;
import com.br.bthbackend.backend.service.ContributionService;
import java.util.List;
import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/contributions"})
public class ContributionController {
    private final ContributionService service;

    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    public Contribution create(@RequestBody Contribution body) {
        return this.service.create(body);
    }

    @PutMapping(value={"/{id}"})
    public Contribution update(@PathVariable Long id, @RequestBody Contribution body) {
        body.setId(id);
        return this.service.update(body);
    }

    @GetMapping(value={"/{id}"})
    public Contribution get(@PathVariable Long id) {
        return this.service.get(id);
    }

    @GetMapping
    public List<Contribution> list() {
        return this.service.list();
    }

    @GetMapping(value={"/code/{code}"})
    public Contribution getByCode(@PathVariable String code) {
        return this.service.getByCode(code);
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void delete(@PathVariable Long id) {
        this.service.delete(id);
    }

    @Generated
    public ContributionController(ContributionService service) {
        this.service = service;
    }
}

